<?php
/**
 * Do not edit this file. It's generated by `jetpack/tools/build-module-headings-translations.php`.
 *
 * @package automattic/jetpack
 */

/**
 * For a given module, return an array with translated name and description.
 *
 * @param string $key Module file name without `.php`.
 *
 * @return array
 */
function jetpack_get_module_i18n( $key ) {
	static $modules;
	if ( ! isset( $modules ) ) {
		$modules = array(
			'action-bar' => array(
				'name' => _x( 'Action Bar (Experimental)', 'Module Name', 'jetpack' ),
				'description' => _x( 'An easy to use way for visitors to follow, like, and comment on your site.', 'Module Description', 'jetpack' ),
			),

			'carousel' => array(
				'name' => _x( 'Carousel', 'Module Name', 'jetpack' ),
				'description' => _x( 'Display images and galleries in a gorgeous, full-screen browsing experience', 'Module Description', 'jetpack' ),
			),

			'comment-likes' => array(
				'name' => _x( 'Comment Likes', 'Module Name', 'jetpack' ),
				'description' => _x( 'Increase visitor engagement by adding a Like button to comments.', 'Module Description', 'jetpack' ),
			),

			'comments' => array(
				'name' => _x( 'Comments', 'Module Name', 'jetpack' ),
				'description' => _x( 'Let visitors use a WordPress.com, Twitter, or Facebook account to comment', 'Module Description', 'jetpack' ),
			),

			'contact-form' => array(
				'name' => _x( 'Contact Form', 'Module Name', 'jetpack' ),
				'description' => _x( 'Add a customizable contact form to any post or page using the Jetpack Form Block.', 'Module Description', 'jetpack' ),
			),

			'copy-post' => array(
				'name' => _x( 'Copy Post', 'Module Name', 'jetpack' ),
				'description' => _x( 'Enable the option to copy entire posts and pages, including tags and settings', 'Module Description', 'jetpack' ),
			),

			'custom-content-types' => array(
				'name' => _x( 'Custom content types', 'Module Name', 'jetpack' ),
				'description' => _x( 'Display different types of content on your site with custom content types.', 'Module Description', 'jetpack' ),
			),

			'custom-css' => array(
				'name' => _x( 'Custom CSS', 'Module Name', 'jetpack' ),
				'description' => _x( 'Adds options for CSS preprocessor use, disabling the theme\'s CSS, or custom image width.', 'Module Description', 'jetpack' ),
			),

			'enhanced-distribution' => array(
				'name' => _x( 'Enhanced Distribution', 'Module Name', 'jetpack' ),
				'description' => _x( 'Increase reach and traffic.', 'Module Description', 'jetpack' ),
			),

			'google-analytics' => array(
				'name' => _x( 'Google Analytics', 'Module Name', 'jetpack' ),
				'description' => _x( 'Set up Google Analytics without touching a line of code.', 'Module Description', 'jetpack' ),
			),

			'google-fonts' => array(
				'name' => _x( 'Google Fonts (Beta)', 'Module Name', 'jetpack' ),
				'description' => _x( 'A selection of Google fonts for block enabled themes. This feature is still being developed.', 'Module Description', 'jetpack' ),
			),

			'gravatar-hovercards' => array(
				'name' => _x( 'Gravatar Hovercards', 'Module Name', 'jetpack' ),
				'description' => _x( 'Enable pop-up business cards over commenters’ Gravatars.', 'Module Description', 'jetpack' ),
			),

			'infinite-scroll' => array(
				'name' => _x( 'Infinite Scroll', 'Module Name', 'jetpack' ),
				'description' => _x( 'Automatically load new content when a visitor scrolls', 'Module Description', 'jetpack' ),
			),

			'json-api' => array(
				'name' => _x( 'JSON API', 'Module Name', 'jetpack' ),
				'description' => _x( 'Allow applications to securely access your content.', 'Module Description', 'jetpack' ),
			),

			'latex' => array(
				'name' => _x( 'Beautiful Math', 'Module Name', 'jetpack' ),
				'description' => _x( 'Use the LaTeX markup language to write mathematical equations and formulas', 'Module Description', 'jetpack' ),
			),

			'lazy-images' => array(
				'name' => _x( 'Lazy Images', 'Module Name', 'jetpack' ),
				'description' => _x( 'Speed up your site and create a smoother viewing experience by loading images as visitors scroll down the screen, instead of all at once.', 'Module Description', 'jetpack' ),
			),

			'likes' => array(
				'name' => _x( 'Likes', 'Module Name', 'jetpack' ),
				'description' => _x( 'Give visitors an easy way to show they appreciate your content.', 'Module Description', 'jetpack' ),
			),

			'markdown' => array(
				'name' => _x( 'Markdown', 'Module Name', 'jetpack' ),
				'description' => _x( 'Write posts or pages in plain-text Markdown syntax', 'Module Description', 'jetpack' ),
			),

			'masterbar' => array(
				'name' => _x( 'WordPress.com Toolbar and Dashboard customizations', 'Module Name', 'jetpack' ),
				'description' => _x( 'Replaces the admin bar with a useful toolbar to quickly manage your site via WordPress.com. Also adds additional customizations to the WPAdmin dashboard experience for better compatibility with WP.com.', 'Module Description', 'jetpack' ),
			),

			'monitor' => array(
				'name' => _x( 'Monitor', 'Module Name', 'jetpack' ),
				'description' => _x( 'Jetpack’s downtime monitoring will continuously watch your site and alert you the moment that downtime is detected.', 'Module Description', 'jetpack' ),
			),

			'notes' => array(
				'name' => _x( 'Notifications', 'Module Name', 'jetpack' ),
				'description' => _x( 'Receive instant notifications of site comments and likes.', 'Module Description', 'jetpack' ),
			),

			'photon-cdn' => array(
				'name' => _x( 'Asset CDN', 'Module Name', 'jetpack' ),
				'description' => _x( 'Jetpack’s Site Accelerator loads your site faster by optimizing your images and serving your images and static files from our global network of servers.', 'Module Description', 'jetpack' ),
			),

			'photon' => array(
				'name' => _x( 'Image CDN', 'Module Name', 'jetpack' ),
				'description' => _x( 'Mirrors and serves your images from our free and fast image CDN, improving your site’s performance with no additional load on your servers.', 'Module Description', 'jetpack' ),
			),

			'post-by-email' => array(
				'name' => _x( 'Post by email', 'Module Name', 'jetpack' ),
				'description' => _x( 'Publish posts by sending an email', 'Module Description', 'jetpack' ),
			),

			'post-list' => array(
				'name' => _x( 'Post List', 'Module Name', 'jetpack' ),
				'description' => _x( 'Display extra information alongside each post in your dashboard’s Posts screen.', 'Module Description', 'jetpack' ),
			),

			'protect' => array(
				'name' => _x( 'Brute force protection', 'Module Name', 'jetpack' ),
				'description' => _x( 'Enabling brute force protection will prevent bots and hackers from attempting to log in to your website with common username and password combinations.', 'Module Description', 'jetpack' ),
			),

			'publicize' => array(
				'name' => _x( 'Jetpack Social', 'Module Name', 'jetpack' ),
				'description' => _x( 'Jetpack Social makes it easy to share your site’s posts on several social media networks automatically when you publish a new post.', 'Module Description', 'jetpack' ),
			),

			'related-posts' => array(
				'name' => _x( 'Related posts', 'Module Name', 'jetpack' ),
				'description' => _x( 'Keep visitors engaged on your blog by highlighting relevant and new content at the bottom of each published post.', 'Module Description', 'jetpack' ),
			),

			'search' => array(
				'name' => _x( 'Search', 'Module Name', 'jetpack' ),
				'description' => _x( 'Help visitors quickly find answers with highly relevant instant search results and powerful filtering.', 'Module Description', 'jetpack' ),
			),

			'seo-tools' => array(
				'name' => _x( 'SEO Tools', 'Module Name', 'jetpack' ),
				'description' => _x( 'Better results on search engines and social media.', 'Module Description', 'jetpack' ),
			),

			'sharedaddy' => array(
				'name' => _x( 'Sharing', 'Module Name', 'jetpack' ),
				'description' => _x( 'Add Twitter and Facebook buttons at the bottom of each post, making it easy for visitors to share your content.', 'Module Description', 'jetpack' ),
			),

			'shortcodes' => array(
				'name' => _x( 'Shortcode Embeds', 'Module Name', 'jetpack' ),
				'description' => _x( 'Shortcodes are WordPress-specific markup that let you add media from popular sites. This feature is no longer necessary as the editor now handles media embeds rather gracefully.', 'Module Description', 'jetpack' ),
			),

			'shortlinks' => array(
				'name' => _x( 'WP.me Shortlinks', 'Module Name', 'jetpack' ),
				'description' => _x( 'Generates shorter links using the wp.me domain.', 'Module Description', 'jetpack' ),
			),

			'sitemaps' => array(
				'name' => _x( 'Sitemaps', 'Module Name', 'jetpack' ),
				'description' => _x( 'Make it easy for search engines to find your site.', 'Module Description', 'jetpack' ),
			),

			'sso' => array(
				'name' => _x( 'Secure Sign On', 'Module Name', 'jetpack' ),
				'description' => _x( 'Allow users to log in to this site using WordPress.com accounts', 'Module Description', 'jetpack' ),
			),

			'stats' => array(
				'name' => _x( 'Jetpack Stats', 'Module Name', 'jetpack' ),
				'description' => _x( 'Collect valuable traffic stats and insights.', 'Module Description', 'jetpack' ),
			),

			'subscriptions' => array(
				'name' => _x( 'Subscriptions', 'Module Name', 'jetpack' ),
				'description' => _x( 'Let visitors subscribe to new posts and comments via email', 'Module Description', 'jetpack' ),
			),

			'tiled-gallery' => array(
				'name' => _x( 'Tiled Galleries', 'Module Name', 'jetpack' ),
				'description' => _x( 'Display image galleries in a variety of elegant arrangements.', 'Module Description', 'jetpack' ),
			),

			'vaultpress' => array(
				'name' => _x( 'Backups and Scanning', 'Module Name', 'jetpack' ),
				'description' => _x( 'Protect your site with daily or real-time backups and automated virus scanning and threat detection.', 'Module Description', 'jetpack' ),
			),

			'verification-tools' => array(
				'name' => _x( 'Site verification', 'Module Name', 'jetpack' ),
				'description' => _x( 'Establish your site\'s authenticity with external services.', 'Module Description', 'jetpack' ),
			),

			'videopress' => array(
				'name' => _x( 'VideoPress', 'Module Name', 'jetpack' ),
				'description' => _x( 'Save on hosting storage and bandwidth costs by streaming fast, ad-free video from our global network.', 'Module Description', 'jetpack' ),
			),

			'waf' => array(
				'name' => _x( 'Firewall', 'Module Name', 'jetpack' ),
				'description' => _x( 'Protect your site with Jetpack\'s Web Application Firewall', 'Module Description', 'jetpack' ),
			),

			'widget-visibility' => array(
				'name' => _x( 'Widget Visibility', 'Module Name', 'jetpack' ),
				'description' => _x( 'Control where widgets appear on your site.', 'Module Description', 'jetpack' ),
			),

			'widgets' => array(
				'name' => _x( 'Extra Sidebar Widgets', 'Module Name', 'jetpack' ),
				'description' => _x( 'Provides additional widgets for use on your site.', 'Module Description', 'jetpack' ),
			),

			'woocommerce-analytics' => array(
				'name' => _x( 'WooCommerce Analytics', 'Module Name', 'jetpack' ),
				'description' => _x( 'Enhanced analytics for WooCommerce and Jetpack users.', 'Module Description', 'jetpack' ),
			),

			'wordads' => array(
				'name' => _x( 'Ads', 'Module Name', 'jetpack' ),
				'description' => _x( 'Earn income by allowing Jetpack to display high quality ads.', 'Module Description', 'jetpack' ),
			),
		);
	}
	return isset( $modules[ $key ] ) ? $modules[ $key ] : null;
}

/**
 * For a given module tag, return its translated version.
 *
 * @param string $key Module tag as is in each module heading.
 *
 * @return string
 */
function jetpack_get_module_i18n_tag( $key ) {
	static $module_tags;
	if ( ! isset( $module_tags ) ) {
		$module_tags = array(
			// Modules with `Other` tag:
			// - modules/contact-form.php
			// - modules/notes.php
			// - modules/woocommerce-analytics.php
			'Other' => _x( 'Other', 'Module Tag', 'jetpack' ),

			// Modules with `Social` tag:
			// - modules/action-bar.php
			// - modules/comment-likes.php
			// - modules/comments.php
			// - modules/gravatar-hovercards.php
			// - modules/likes.php
			// - modules/publicize.php
			// - modules/seo-tools.php
			// - modules/sharedaddy.php
			// - modules/shortcodes.php
			// - modules/shortlinks.php
			// - modules/subscriptions.php
			// - modules/widgets.php
			'Social' => _x( 'Social', 'Module Tag', 'jetpack' ),

			// Modules with `Photos and Videos` tag:
			// - modules/carousel.php
			// - modules/photon-cdn.php
			// - modules/photon.php
			// - modules/shortcodes.php
			// - modules/tiled-gallery.php
			// - modules/videopress.php
			'Photos and Videos' => _x( 'Photos and Videos', 'Module Tag', 'jetpack' ),

			// Modules with `Writing` tag:
			// - modules/copy-post.php
			// - modules/custom-content-types.php
			// - modules/enhanced-distribution.php
			// - modules/json-api.php
			// - modules/latex.php
			// - modules/markdown.php
			// - modules/post-by-email.php
			// - modules/shortcodes.php
			'Writing' => _x( 'Writing', 'Module Tag', 'jetpack' ),

			// Modules with `Appearance` tag:
			// - modules/custom-css.php
			// - modules/gravatar-hovercards.php
			// - modules/infinite-scroll.php
			// - modules/lazy-images.php
			// - modules/photon-cdn.php
			// - modules/photon.php
			// - modules/seo-tools.php
			// - modules/shortcodes.php
			// - modules/widget-visibility.php
			// - modules/widgets.php
			// - modules/wordads.php
			'Appearance' => _x( 'Appearance', 'Module Tag', 'jetpack' ),

			// Modules with `Fonts` tag:
			// - modules/google-fonts.php
			'Fonts' => _x( 'Fonts', 'Module Tag', 'jetpack' ),

			// Modules with `Recommended` tag:
			// - modules/google-fonts.php
			// - modules/lazy-images.php
			// - modules/monitor.php
			// - modules/photon-cdn.php
			// - modules/photon.php
			// - modules/protect.php
			// - modules/publicize.php
			// - modules/related-posts.php
			// - modules/sharedaddy.php
			// - modules/sitemaps.php
			// - modules/stats.php
			// - modules/woocommerce-analytics.php
			'Recommended' => _x( 'Recommended', 'Module Tag', 'jetpack' ),

			// Modules with `Developers` tag:
			// - modules/json-api.php
			// - modules/sso.php
			'Developers' => _x( 'Developers', 'Module Tag', 'jetpack' ),

			// Modules with `General` tag:
			// - modules/masterbar.php
			'General' => _x( 'General', 'Module Tag', 'jetpack' ),

			// Modules with `Admin` tag:
			// - modules/post-list.php
			'Admin' => _x( 'Admin', 'Module Tag', 'jetpack' ),

			// Modules with `Traffic` tag:
			// - modules/sitemaps.php
			// - modules/wordads.php
			'Traffic' => _x( 'Traffic', 'Module Tag', 'jetpack' ),

			// Modules with `Jetpack Stats` tag:
			// - modules/stats.php
			'Jetpack Stats' => _x( 'Jetpack Stats', 'Module Tag', 'jetpack' ),

			// Modules with `Site Stats` tag:
			// - modules/stats.php
			'Site Stats' => _x( 'Site Stats', 'Module Tag', 'jetpack' ),

			// Modules with `Firewall` tag:
			// - modules/waf.php
			'Firewall' => _x( 'Firewall', 'Module Tag', 'jetpack' ),

			// Modules with `WAF` tag:
			// - modules/waf.php
			'WAF' => _x( 'WAF', 'Module Tag', 'jetpack' ),
		);
	}
	return ! empty( $module_tags[ $key ] ) ? $module_tags[ $key ] : '';
}

/**
 * For a given module, return an array with the module info.
 *
 * @param string $key Module file name without `.php`.
 *
 * return array|string An array containing the module info or an empty string if the given module isn't known.
 */
function jetpack_get_module_info( $key ) {
	static $module_info = array (
	  'action-bar' => 
	  array (
	    'name' => 'Action Bar (Experimental)',
	    'description' => 'An easy to use way for visitors to follow, like, and comment on your site.',
	    'sort' => '40',
	    'recommendation_order' => '18',
	    'introduced' => '11.4',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Social',
	    'feature' => 'Engagement',
	    'additional_search_queries' => 'adminbar, actionbar, comments, likes, follow, sharing',
	    'plan_classes' => '',
	  ),
	  'carousel' => 
	  array (
	    'name' => 'Carousel',
	    'description' => 'Display images and galleries in a gorgeous, full-screen browsing experience',
	    'sort' => '22',
	    'recommendation_order' => '12',
	    'introduced' => '1.5',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'No',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Photos and Videos',
	    'feature' => 'Appearance',
	    'additional_search_queries' => 'gallery, carousel, diaporama, slideshow, images, lightbox, exif, metadata, image',
	    'plan_classes' => '',
	  ),
	  'comment-likes' => 
	  array (
	    'name' => 'Comment Likes',
	    'description' => 'Increase visitor engagement by adding a Like button to comments.',
	    'sort' => '39',
	    'recommendation_order' => '17',
	    'introduced' => '5.1',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Social',
	    'feature' => '',
	    'additional_search_queries' => 'like widget, like button, like, likes',
	    'plan_classes' => '',
	  ),
	  'comments' => 
	  array (
	    'name' => 'Comments',
	    'description' => 'Let visitors use a WordPress.com, Twitter, or Facebook account to comment',
	    'sort' => '20',
	    'recommendation_order' => '',
	    'introduced' => '1.4',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Social',
	    'feature' => 'Engagement',
	    'additional_search_queries' => 'comments, comment, facebook, twitter, social',
	    'plan_classes' => '',
	  ),
	  'contact-form' => 
	  array (
	    'name' => 'Contact Form',
	    'description' => 'Add a customizable contact form to any post or page using the Jetpack Form Block.',
	    'sort' => '15',
	    'recommendation_order' => '14',
	    'introduced' => '1.3',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'No',
	    'requires_user_connection' => '',
	    'auto_activate' => 'Yes',
	    'module_tags' => 'Other',
	    'feature' => 'Writing',
	    'additional_search_queries' => 'contact, form, grunion, feedback, submission, contact form, email, feedback, contact form plugin, custom form, custom form plugin, form builder, forms, form maker, survey, contact by jetpack, contact us, forms free',
	    'plan_classes' => '',
	  ),
	  'copy-post' => 
	  array (
	    'name' => 'Copy Post',
	    'description' => 'Enable the option to copy entire posts and pages, including tags and settings',
	    'sort' => '15',
	    'recommendation_order' => '',
	    'introduced' => '7.0',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'No',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Writing',
	    'feature' => 'Writing',
	    'additional_search_queries' => 'copy, duplicate',
	    'plan_classes' => '',
	  ),
	  'custom-content-types' => 
	  array (
	    'name' => 'Custom content types',
	    'description' => 'Display different types of content on your site with custom content types.',
	    'sort' => '34',
	    'recommendation_order' => '',
	    'introduced' => '3.1',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'No',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Writing',
	    'feature' => 'Writing',
	    'additional_search_queries' => 'cpt, custom post types, portfolio, portfolios, testimonial, testimonials',
	    'plan_classes' => '',
	  ),
	  'custom-css' => 
	  array (
	    'name' => 'Custom CSS',
	    'description' => 'Adds options for CSS preprocessor use, disabling the theme\'s CSS, or custom image width.',
	    'sort' => '2',
	    'recommendation_order' => '',
	    'introduced' => '1.7',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'No',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Appearance',
	    'feature' => 'Appearance',
	    'additional_search_queries' => 'css, customize, custom, style, editor, less, sass, preprocessor, font, mobile, appearance, theme, stylesheet',
	    'plan_classes' => '',
	  ),
	  'enhanced-distribution' => 
	  array (
	    'name' => 'Enhanced Distribution',
	    'description' => 'Increase reach and traffic.',
	    'sort' => '5',
	    'recommendation_order' => '',
	    'introduced' => '1.2',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => '',
	    'auto_activate' => 'Public',
	    'module_tags' => 'Writing',
	    'feature' => 'Engagement',
	    'additional_search_queries' => 'google, seo, firehose, search, broadcast, broadcasting',
	    'plan_classes' => '',
	  ),
	  'google-analytics' => 
	  array (
	    'name' => 'Google Analytics',
	    'description' => 'Set up Google Analytics without touching a line of code.',
	    'sort' => '37',
	    'recommendation_order' => '',
	    'introduced' => '4.5',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => '',
	    'feature' => 'Engagement',
	    'additional_search_queries' => 'webmaster, google, analytics, console',
	    'plan_classes' => 'business, premium, security, complete',
	  ),
	  'google-fonts' => 
	  array (
	    'name' => 'Google Fonts (Beta)',
	    'description' => 'A selection of Google fonts for block enabled themes. This feature is still being developed.',
	    'sort' => '1',
	    'recommendation_order' => '2',
	    'introduced' => '10.8.0',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'No',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Fonts, Recommended',
	    'feature' => 'Writing',
	    'additional_search_queries' => 'fonts, webfonts, typography',
	    'plan_classes' => '',
	  ),
	  'gravatar-hovercards' => 
	  array (
	    'name' => 'Gravatar Hovercards',
	    'description' => 'Enable pop-up business cards over commenters’ Gravatars.',
	    'sort' => '11',
	    'recommendation_order' => '13',
	    'introduced' => '1.1',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'No',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Social, Appearance',
	    'feature' => 'Appearance',
	    'additional_search_queries' => 'gravatar, hovercards',
	    'plan_classes' => '',
	  ),
	  'infinite-scroll' => 
	  array (
	    'name' => 'Infinite Scroll',
	    'description' => 'Automatically load new content when a visitor scrolls',
	    'sort' => '26',
	    'recommendation_order' => '',
	    'introduced' => '2.0',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'No',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Appearance',
	    'feature' => 'Appearance',
	    'additional_search_queries' => 'scroll, infinite, infinite scroll',
	    'plan_classes' => '',
	  ),
	  'json-api' => 
	  array (
	    'name' => 'JSON API',
	    'description' => 'Allow applications to securely access your content.',
	    'sort' => '19',
	    'recommendation_order' => '',
	    'introduced' => '1.9',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => '',
	    'auto_activate' => 'Public',
	    'module_tags' => 'Writing, Developers',
	    'feature' => 'General',
	    'additional_search_queries' => 'api, rest, develop, developers, json, klout, oauth',
	    'plan_classes' => '',
	  ),
	  'latex' => 
	  array (
	    'name' => 'Beautiful Math',
	    'description' => 'Use the LaTeX markup language to write mathematical equations and formulas',
	    'sort' => '12',
	    'recommendation_order' => '',
	    'introduced' => '1.1',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'No',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Writing',
	    'feature' => 'Writing',
	    'additional_search_queries' => 'latex, math, equation, equations, formula, code',
	    'plan_classes' => '',
	  ),
	  'lazy-images' => 
	  array (
	    'name' => 'Lazy Images',
	    'description' => 'Speed up your site and create a smoother viewing experience by loading images as visitors scroll down the screen, instead of all at once.',
	    'sort' => '24',
	    'recommendation_order' => '14',
	    'introduced' => '5.6.0',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'No',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Appearance, Recommended',
	    'feature' => 'Appearance',
	    'additional_search_queries' => 'mobile, theme, fast images, fast image, image, lazy, lazy load, lazyload, images, lazy images, thumbnail, image lazy load, lazy loading, load, loading',
	    'plan_classes' => '',
	  ),
	  'likes' => 
	  array (
	    'name' => 'Likes',
	    'description' => 'Give visitors an easy way to show they appreciate your content.',
	    'sort' => '23',
	    'recommendation_order' => '',
	    'introduced' => '2.2',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Social',
	    'feature' => 'Engagement',
	    'additional_search_queries' => 'like, likes, wordpress.com',
	    'plan_classes' => '',
	  ),
	  'markdown' => 
	  array (
	    'name' => 'Markdown',
	    'description' => 'Write posts or pages in plain-text Markdown syntax',
	    'sort' => '31',
	    'recommendation_order' => '',
	    'introduced' => '2.8',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'No',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Writing',
	    'feature' => 'Writing',
	    'additional_search_queries' => 'md, markdown',
	    'plan_classes' => '',
	  ),
	  'masterbar' => 
	  array (
	    'name' => 'WordPress.com Toolbar and Dashboard customizations',
	    'description' => 'Replaces the admin bar with a useful toolbar to quickly manage your site via WordPress.com. Also adds additional customizations to the WPAdmin dashboard experience for better compatibility with WP.com.',
	    'sort' => '38',
	    'recommendation_order' => '16',
	    'introduced' => '4.8',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => 'Yes',
	    'auto_activate' => 'No',
	    'module_tags' => 'General',
	    'feature' => '',
	    'additional_search_queries' => 'adminbar, masterbar, colorschemes, profile-edit',
	    'plan_classes' => '',
	  ),
	  'monitor' => 
	  array (
	    'name' => 'Monitor',
	    'description' => 'Jetpack’s downtime monitoring will continuously watch your site and alert you the moment that downtime is detected.',
	    'sort' => '28',
	    'recommendation_order' => '10',
	    'introduced' => '2.6',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => 'Yes',
	    'auto_activate' => 'No',
	    'module_tags' => 'Recommended',
	    'feature' => 'Security',
	    'additional_search_queries' => 'monitor, uptime, downtime, monitoring, maintenance, maintenance mode, offline, site is down, site down, down, repair, error',
	    'plan_classes' => '',
	  ),
	  'notes' => 
	  array (
	    'name' => 'Notifications',
	    'description' => 'Receive instant notifications of site comments and likes.',
	    'sort' => '13',
	    'recommendation_order' => '',
	    'introduced' => '1.9',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => 'Yes',
	    'auto_activate' => 'Yes',
	    'module_tags' => 'Other',
	    'feature' => 'General',
	    'additional_search_queries' => 'notification, notifications, toolbar, adminbar, push, comments',
	    'plan_classes' => '',
	  ),
	  'photon-cdn' => 
	  array (
	    'name' => 'Asset CDN',
	    'description' => 'Jetpack’s Site Accelerator loads your site faster by optimizing your images and serving your images and static files from our global network of servers.',
	    'sort' => '26',
	    'recommendation_order' => '1',
	    'introduced' => '6.6',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'No',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Photos and Videos, Appearance, Recommended',
	    'feature' => 'Recommended, Appearance',
	    'additional_search_queries' => 'site accelerator, accelerate, static, assets, javascript, css, files, performance, cdn, bandwidth, content delivery network, pagespeed, combine js, optimize css',
	    'plan_classes' => '',
	  ),
	  'photon' => 
	  array (
	    'name' => 'Image CDN',
	    'description' => 'Mirrors and serves your images from our free and fast image CDN, improving your site’s performance with no additional load on your servers.',
	    'sort' => '25',
	    'recommendation_order' => '1',
	    'introduced' => '2.0',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Photos and Videos, Appearance, Recommended',
	    'feature' => 'Recommended, Appearance',
	    'additional_search_queries' => 'photon, photo cdn, image cdn, speed, compression, resize, responsive images, responsive, content distribution network, optimize, page speed, image optimize, photon jetpack',
	    'plan_classes' => '',
	  ),
	  'post-by-email' => 
	  array (
	    'name' => 'Post by email',
	    'description' => 'Publish posts by sending an email',
	    'sort' => '14',
	    'recommendation_order' => '',
	    'introduced' => '2.0',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => 'Yes',
	    'auto_activate' => 'No',
	    'module_tags' => 'Writing',
	    'feature' => 'Writing',
	    'additional_search_queries' => 'post by email, email',
	    'plan_classes' => '',
	  ),
	  'post-list' => 
	  array (
	    'name' => 'Post List',
	    'description' => 'Display extra information alongside each post in your dashboard’s Posts screen.',
	    'sort' => '31',
	    'recommendation_order' => '12',
	    'introduced' => '11.3',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'No',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Admin',
	    'feature' => 'Appearance',
	    'additional_search_queries' => 'post, admin, list',
	    'plan_classes' => '',
	  ),
	  'protect' => 
	  array (
	    'name' => 'Brute force protection',
	    'description' => 'Enabling brute force protection will prevent bots and hackers from attempting to log in to your website with common username and password combinations.',
	    'sort' => '1',
	    'recommendation_order' => '4',
	    'introduced' => '3.4',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => 'Yes',
	    'auto_activate' => 'Yes',
	    'module_tags' => 'Recommended',
	    'feature' => 'Security',
	    'additional_search_queries' => 'security, jetpack protect, secure, protection, botnet, brute force, protect, login, bot, password, passwords, strong passwords, strong password, wp-login.php,  protect admin',
	    'plan_classes' => '',
	  ),
	  'publicize' => 
	  array (
	    'name' => 'Jetpack Social',
	    'description' => 'Jetpack Social makes it easy to share your site’s posts on several social media networks automatically when you publish a new post.',
	    'sort' => '10',
	    'recommendation_order' => '7',
	    'introduced' => '2.0',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => 'Yes',
	    'auto_activate' => 'No',
	    'module_tags' => 'Social, Recommended',
	    'feature' => 'Engagement',
	    'additional_search_queries' => 'facebook, jetpack publicize, twitter, tumblr, linkedin, social, tweet, connections, sharing, social media, automated, automated sharing, auto publish, auto tweet and like, auto tweet, facebook auto post, facebook posting',
	    'plan_classes' => '',
	  ),
	  'related-posts' => 
	  array (
	    'name' => 'Related posts',
	    'description' => 'Keep visitors engaged on your blog by highlighting relevant and new content at the bottom of each published post.',
	    'sort' => '29',
	    'recommendation_order' => '9',
	    'introduced' => '2.9',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Recommended',
	    'feature' => 'Engagement',
	    'additional_search_queries' => 'related, jetpack related posts, related posts for wordpress, related posts, popular posts, popular, related content, related post, contextual, context, contextual related posts, related articles, similar posts, easy related posts, related page, simple related posts, free related posts, related thumbnails, similar, engagement, yet another related posts plugin',
	    'plan_classes' => '',
	  ),
	  'search' => 
	  array (
	    'name' => 'Search',
	    'description' => 'Help visitors quickly find answers with highly relevant instant search results and powerful filtering.',
	    'sort' => '34',
	    'recommendation_order' => '',
	    'introduced' => '5.0',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => 'false',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => '',
	    'feature' => 'Search',
	    'additional_search_queries' => 'search, elastic, elastic search, elasticsearch, fast search, search results, search performance, google search',
	    'plan_classes' => 'business, complete',
	  ),
	  'seo-tools' => 
	  array (
	    'name' => 'SEO Tools',
	    'description' => 'Better results on search engines and social media.',
	    'sort' => '35',
	    'recommendation_order' => '15',
	    'introduced' => '4.4',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => 'No',
	    'auto_activate' => 'No',
	    'module_tags' => 'Social, Appearance',
	    'feature' => 'Traffic',
	    'additional_search_queries' => 'search engine optimization, social preview, meta description, custom title format',
	    'plan_classes' => '',
	  ),
	  'sharedaddy' => 
	  array (
	    'name' => 'Sharing',
	    'description' => 'Add Twitter and Facebook buttons at the bottom of each post, making it easy for visitors to share your content.',
	    'sort' => '7',
	    'recommendation_order' => '6',
	    'introduced' => '1.1',
	    'changed' => '1.2',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'No',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Social, Recommended',
	    'feature' => 'Engagement',
	    'additional_search_queries' => 'share, sharing, sharedaddy, social buttons, buttons, share facebook, share twitter, social media sharing, social media share, social share, icons, email, facebook, twitter, linkedin, pinterest, pocket, social widget, social media',
	    'plan_classes' => '',
	  ),
	  'shortcodes' => 
	  array (
	    'name' => 'Shortcode Embeds',
	    'description' => 'Shortcodes are WordPress-specific markup that let you add media from popular sites. This feature is no longer necessary as the editor now handles media embeds rather gracefully.',
	    'sort' => '3',
	    'recommendation_order' => '',
	    'introduced' => '1.1',
	    'changed' => '1.2',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'No',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Photos and Videos, Social, Writing, Appearance',
	    'feature' => 'Writing',
	    'additional_search_queries' => 'shortcodes, shortcode, embeds, media, bandcamp, dailymotion, facebook, flickr, google calendars, google maps, polldaddy, recipe, recipes, scribd, slideshare, slideshow, slideshows, soundcloud, ted, twitter, vimeo, vine, youtube',
	    'plan_classes' => '',
	  ),
	  'shortlinks' => 
	  array (
	    'name' => 'WP.me Shortlinks',
	    'description' => 'Generates shorter links using the wp.me domain.',
	    'sort' => '8',
	    'recommendation_order' => '',
	    'introduced' => '1.1',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Social',
	    'feature' => 'Writing',
	    'additional_search_queries' => 'shortlinks, wp.me',
	    'plan_classes' => '',
	  ),
	  'sitemaps' => 
	  array (
	    'name' => 'Sitemaps',
	    'description' => 'Make it easy for search engines to find your site.',
	    'sort' => '13',
	    'recommendation_order' => '',
	    'introduced' => '3.9',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'No',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Recommended, Traffic',
	    'feature' => 'Recommended',
	    'additional_search_queries' => 'sitemap, traffic, search, site map, seo',
	    'plan_classes' => '',
	  ),
	  'sso' => 
	  array (
	    'name' => 'Secure Sign On',
	    'description' => 'Allow users to log in to this site using WordPress.com accounts',
	    'sort' => '30',
	    'recommendation_order' => '5',
	    'introduced' => '2.6',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => 'Yes',
	    'auto_activate' => 'No',
	    'module_tags' => 'Developers',
	    'feature' => 'Security',
	    'additional_search_queries' => 'sso, single sign on, login, log in, 2fa, two-factor',
	    'plan_classes' => '',
	  ),
	  'stats' => 
	  array (
	    'name' => 'Jetpack Stats',
	    'description' => 'Collect valuable traffic stats and insights.',
	    'sort' => '1',
	    'recommendation_order' => '2',
	    'introduced' => '1.1',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => '',
	    'auto_activate' => 'Yes',
	    'module_tags' => 'Jetpack Stats, Site Stats, Recommended',
	    'feature' => 'Engagement',
	    'additional_search_queries' => 'statistics, tracking, analytics, views, traffic, stats',
	    'plan_classes' => '',
	  ),
	  'subscriptions' => 
	  array (
	    'name' => 'Subscriptions',
	    'description' => 'Let visitors subscribe to new posts and comments via email',
	    'sort' => '9',
	    'recommendation_order' => '8',
	    'introduced' => '1.2',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => 'Yes',
	    'auto_activate' => 'No',
	    'module_tags' => 'Social',
	    'feature' => 'Engagement',
	    'additional_search_queries' => 'subscriptions, subscription, email, follow, followers, subscribers, signup',
	    'plan_classes' => '',
	  ),
	  'tiled-gallery' => 
	  array (
	    'name' => 'Tiled Galleries',
	    'description' => 'Display image galleries in a variety of elegant arrangements.',
	    'sort' => '24',
	    'recommendation_order' => '',
	    'introduced' => '2.1',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'No',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Photos and Videos',
	    'feature' => 'Appearance',
	    'additional_search_queries' => 'gallery, tiles, tiled, grid, mosaic, images',
	    'plan_classes' => '',
	  ),
	  'vaultpress' => 
	  array (
	    'name' => 'Backups and Scanning',
	    'description' => 'Protect your site with daily or real-time backups and automated virus scanning and threat detection.',
	    'sort' => '32',
	    'recommendation_order' => '',
	    'introduced' => '0:1.2',
	    'changed' => '',
	    'deactivate' => 'false',
	    'free' => 'false',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => '',
	    'feature' => 'Security, Health',
	    'additional_search_queries' => 'backup, cloud backup, database backup, restore, wordpress backup, backup plugin, wordpress backup plugin, back up, backup wordpress, backwpup, vaultpress, backups, off-site backups, offsite backup, offsite, off-site, antivirus, malware scanner, security, virus, viruses, prevent viruses, scan, anti-virus, antimalware, protection, safe browsing, malware, wp security, wordpress security',
	    'plan_classes' => 'personal, business, premium, security, complete',
	  ),
	  'verification-tools' => 
	  array (
	    'name' => 'Site verification',
	    'description' => 'Establish your site\'s authenticity with external services.',
	    'sort' => '33',
	    'recommendation_order' => '',
	    'introduced' => '3.0',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'No',
	    'requires_user_connection' => '',
	    'auto_activate' => 'Yes',
	    'module_tags' => '',
	    'feature' => 'Engagement',
	    'additional_search_queries' => 'webmaster, seo, google, bing, pinterest, search, console',
	    'plan_classes' => '',
	  ),
	  'videopress' => 
	  array (
	    'name' => 'VideoPress',
	    'description' => 'Save on hosting storage and bandwidth costs by streaming fast, ad-free video from our global network.',
	    'sort' => '27',
	    'recommendation_order' => '',
	    'introduced' => '2.5',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => '',
	    'auto_activate' => '',
	    'module_tags' => 'Photos and Videos',
	    'feature' => 'Writing',
	    'additional_search_queries' => 'video, videos, videopress, video gallery, video player, videoplayer, mobile video, vimeo, youtube, html5 video, stream',
	    'plan_classes' => '',
	  ),
	  'waf' => 
	  array (
	    'name' => 'Firewall',
	    'description' => 'Protect your site with Jetpack\'s Web Application Firewall',
	    'sort' => '5',
	    'recommendation_order' => '',
	    'introduced' => '10.9',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Firewall, WAF',
	    'feature' => 'Security',
	    'additional_search_queries' => '',
	    'plan_classes' => '',
	  ),
	  'widget-visibility' => 
	  array (
	    'name' => 'Widget Visibility',
	    'description' => 'Control where widgets appear on your site.',
	    'sort' => '17',
	    'recommendation_order' => '',
	    'introduced' => '2.4',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'No',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Appearance',
	    'feature' => 'Appearance',
	    'additional_search_queries' => 'widget visibility, logic, conditional, widgets, widget',
	    'plan_classes' => '',
	  ),
	  'widgets' => 
	  array (
	    'name' => 'Extra Sidebar Widgets',
	    'description' => 'Provides additional widgets for use on your site.',
	    'sort' => '4',
	    'recommendation_order' => '',
	    'introduced' => '1.2',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'No',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Social, Appearance',
	    'feature' => 'Appearance',
	    'additional_search_queries' => 'widget, widgets, facebook, gallery, twitter, gravatar, image, rss',
	    'plan_classes' => '',
	  ),
	  'woocommerce-analytics' => 
	  array (
	    'name' => 'WooCommerce Analytics',
	    'description' => 'Enhanced analytics for WooCommerce and Jetpack users.',
	    'sort' => '13',
	    'recommendation_order' => '',
	    'introduced' => '8.4',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => '',
	    'auto_activate' => 'Yes',
	    'module_tags' => 'Other, Recommended',
	    'feature' => 'Engagement',
	    'additional_search_queries' => 'woocommerce, analytics, stats, statistics, tracking, analytics, views',
	    'plan_classes' => '',
	  ),
	  'wordads' => 
	  array (
	    'name' => 'Ads',
	    'description' => 'Earn income by allowing Jetpack to display high quality ads.',
	    'sort' => '1',
	    'recommendation_order' => '',
	    'introduced' => '4.5.0',
	    'changed' => '',
	    'deactivate' => '',
	    'free' => '',
	    'requires_connection' => 'Yes',
	    'requires_user_connection' => '',
	    'auto_activate' => 'No',
	    'module_tags' => 'Traffic, Appearance',
	    'feature' => '',
	    'additional_search_queries' => 'advertising, ad codes, ads',
	    'plan_classes' => 'premium, business, security, complete',
	  ),
	);
	return isset( $module_info[ $key ] ) ? $module_info[ $key ] : null;
}

/**
 * Return an array containing all module header names.
 *
 * @return array
 */
function jetpack_get_all_module_header_names() {
	return array (
	  'name' => 'Module Name',
	  'description' => 'Module Description',
	  'sort' => 'Sort Order',
	  'recommendation_order' => 'Recommendation Order',
	  'introduced' => 'First Introduced',
	  'changed' => 'Major Changes In',
	  'deactivate' => 'Deactivate',
	  'free' => 'Free',
	  'requires_connection' => 'Requires Connection',
	  'requires_user_connection' => 'Requires User Connection',
	  'auto_activate' => 'Auto Activate',
	  'module_tags' => 'Module Tags',
	  'feature' => 'Feature',
	  'additional_search_queries' => 'Additional Search Queries',
	  'plan_classes' => 'Plans',
	);
}

/**
 * Returns whether the file associated with the given slug has no module info.
 *
 * @param string $slug The slug name.
 *
 * @return bool Whether the file has no module info.
 */
function jetpack_has_no_module_info( $slug ) {
	$no_info_slugs = array (
	  0 => 'geo-location',
	  1 => 'module-extras',
	  2 => 'module-info',
	  3 => 'plugin-search',
	  4 => 'theme-tools',
	);

	return in_array( $slug, $no_info_slugs, true );
}
